unit DiakFeltolt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TForm3 = class(TForm)
    Label1: TLabel;
    DNev: TEdit;
    Label2: TLabel;
    Dtankor: TEdit;
    UpDown1: TUpDown;
    Label3: TLabel;
    Dkredit: TEdit;
    UpDown2: TUpDown;
    GroupBox1: TGroupBox;
    ListBox1: TListBox;
    Etankor: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Ekredit: TEdit;
    HozzaAd: TButton;
    Bezar: TButton;
    Torles: TButton;
    Adatmentes: TButton;
    SaveDialog1: TSaveDialog;
    AdatokTorlese: TButton;
    procedure HozzaAdClick(Sender: TObject);
    procedure BezarClick(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure TorlesClick(Sender: TObject);
    procedure AdatmentesClick(Sender: TObject);
    procedure AdatokTorleseClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation
uses DiakAdat, Diakm;
{$R *.DFM}

procedure TForm3.HozzaAdClick(Sender: TObject);
var
    d: TDiak;
    t,k:integer;
begin
  t :=  StrToInt(Dtankor.Text);
  k :=  StrToInt(Dkredit.Text);
  if (DNev.Text <> '') and (t > 0) and (k > 0) then
   begin
      ListBox1.Items.Add(DNev.Text);
      Etankor.Text := Dtankor.Text;
      Ekredit.Text := Dkredit.Text;
      d:= TDiak.DCreate;
      d.nev := DNev.Text;
      d.tankor  := t;
      d.kreditpont:= k;
      Dnev.Clear;
      Dtankor.Clear;
      Dkredit.Clear;
      d.elozo := nil;
      d.kovetkezo := nil;
      if Evf.elso = nil then Evf.elso := d
       else
        begin
          Evf.utolso.kovetkezo := d;
          d.elozo := Evf.utolso;
        end;
        Evf.utolso := d;
   end;
end;

procedure TForm3.BezarClick(Sender: TObject);
begin
   if Assigned (Evf.elso) then
   begin
     Form1.Megjelenites.Enabled := true;
     Form1.Kiertekeles.Enabled := true;
   end;
   Close;
end;

procedure TForm3.ListBox1Click(Sender: TObject);
var
   p:TDiak;
begin
   If ListBox1.ItemIndex>=0 then
     begin
       p:= Evf.elso;
       while p <> nil do
        begin
          if ListBox1.Items[ListBox1.ItemIndex] = p.nev then
            begin
              Etankor.Text := IntToStr(p.tankor);
              Ekredit.Text := IntToStr(p.kreditpont);
              break;
            end;
            p:= p.kovetkezo;
        end;
     end;
end;

procedure TForm3.TorlesClick(Sender: TObject);
var
   p, pAct:TDiak;
begin
   If ListBox1.ItemIndex>-1 then
     begin
       p:= Evf.elso;
       while p <> nil do
       begin
          pAct := p;
          Etankor.Text := IntToStr(pAct.tankor);
          Ekredit.Text := IntToStr(pAct.kreditpont);
          if ListBox1.Items[ListBox1.ItemIndex]= pAct.nev then
           begin
                ListBox1.Items.Delete(ListBox1.ItemIndex);
                Etankor.Clear;
                Ekredit.Clear;
                if pAct = Evf.elso then
                  begin
                    Evf.elso := Evf.elso.kovetkezo;
                    if Evf.elso <> nil then Evf.elso.elozo := nil
                                       else Evf.utolso := nil;
                  end
                  else
                  if pAct = Evf.utolso then
                  begin
                     pAct := Evf.utolso.elozo;
                     pAct.kovetkezo := nil;
                     Evf.utolso := pAct;
                  end
                  else
                  begin
                    pAct.elozo.kovetkezo := pAct.kovetkezo;
                    pAct.kovetkezo.elozo := pAct.elozo;
                  end;
                  p.Destroy;
                  p:= nil;
                  break;
                end;
                p:= p.kovetkezo;
           end;
     end;
end;

procedure TForm3.AdatmentesClick(Sender: TObject);
var
  Outf: TextFile;
  p   : TDiak;
begin
  if Assigned (Evf.elso) then
   begin
     SaveDialog1.FileName := '*.dat';
     if SaveDialog1.Execute then
      begin
        FNev:=SaveDialog1.FileName;
        Form1.Caption := 'Adat mentse: ' +
        ExtractFileName(SaveDialog1.FileName);
        AssignFile(Outf,FNev);
        Rewrite(Outf);
        p := Evf.elso;
        while p <> nil do
         begin
           Writeln(Outf,p.nev:20,p.tankor:3,p.kreditpont:4);
           p := p.kovetkezo;
         end;
        CloseFile(Outf);
        Form3.Caption:= Form1.Caption;
      end;
   end;
end;

procedure TForm3.AdatokTorleseClick(Sender: TObject);
begin
  if Assigned (Evf.elso) then
  begin
    Evf.EFree;
    Evf:= TEvf.ECreate;
    Evf.elso := nil;
    Form1.Megjelenites.Enabled := false;
    Form1.Kiertekeles.Enabled := false;
    Etankor.Clear;
    Ekredit.Clear;
    ListBox1.Clear;
  end;
end;

end.
